
# estPi.py
# info: http://en.wikipedia.org/wiki/Coprime_integers

import math, random

MAX_NUM = 10000000000

def estPi(nPairs):
  count = 0
  for i in range(0, nPairs):
    n1 = random.randint(1, MAX_NUM)
    n2 = random.randint(1, MAX_NUM)
    # increment the counter if both integers are coprimes
    if math.gcd(n1, n2) == 1:
      count += 1
  prob = float(count)/nPairs   
  return math.sqrt(6 / prob)

nPairs = 1000000
print("Generating", nPairs, "random pairs")
piEst = estPi(nPairs)
print(" pi est:", piEst)
print("math.pi:", math.pi)
