
# emirps.py

'''
Print the first 20 eprimes.

   An emirp (prime spelled backwards) are primes that when
   reversed (in their decimal representation) become different
   primes. (This rules out palindromic primes.)

   https://rosettacode.org/wiki/Emirp_primes#Java
'''

import math
from prime import *

def reverse(x):
  rev = 0
  while x > 0:
    rev = (rev * 10) + x%10
    x = x //10
  return rev


def isEmirp(n):
  rev = reverse(n)
  return isPrime[n] and isPrime[rev] and (n != rev)


# ---------- main -----------

n = 10000
isPrime = sieve(n)
count = 0
i = 2
while count < 20 and i < n:
  if isEmirp(i):
    count += 1
    print(i, end=' ')
  i += 1
print()
