# sbTree.py 
# input: 3
'''
  The Stern-Brocot tree
  https://en.wikipedia.org/wiki/Stern%E2%80%93Brocot_tree

Ronald L. Graham, Donald E. Knuth and Oren Patashnik, Concrete Mathematics. Addison-Wesley, Reading, MA, 1990, Section 4.5, p. 117.
'''


def expand(fracs):
  nFracs = []
  i = 0
  while i < len(fracs)-1: 
    nFracs.append( fracs[i])
    nFracs.append( mediant( fracs[i], fracs[i+1]))
    i += 1
  nFracs.append( fracs[-1])
  return nFracs

def mediant(f1, f2):
  return (f1[0] + f2[0], f1[1] + f2[1])

lvls = int(input("lvls=? "))
fracs = [ (0, 1), (1, 0) ]  # cannot use fraction for 1/0
for i in range(lvls):
  fracs = expand(fracs)
print(*fracs)
