# sbSeq.py 
# https://oeis.org/A002487 
# input: 40
'''
  The Stern-Brocot sequence
  f(n)/f(n+1) runs through all the reduced nonnegative rationals exactly once

  https://en.wikipedia.org/wiki/Stern%E2%80%93Brocot_tree

Ronald L. Graham, Donald E. Knuth and Oren Patashnik, Concrete Mathematics. Addison-Wesley, Reading, MA, 1990, Section 4.5, p. 117.
'''

from fractions import Fraction as F

def f(n):
  if n < 2:
    return n
  elif (n % 2 == 0):  # even
    return f(n//2)
  else: 
    return f((n-1)//2) + f((n+1)//2)


n = int(input("n=? "))
col = 0
for i in range(n):
  if i%20 == 0:
    print()
  print(f"{f(i):3}", end = '')
print()

print()
prev = f(0)
for i in range(1,n):
  curr = f(i)
  frac = F(prev,curr)
  print(frac, end = ' ')
  if frac.denominator == 1:
    print()
  prev = curr
print()