
# ulam107
# Fig. 10.7 
# (1, 2)-Ulam sequence
# https://mathworld.wolfram.com/UlamSequence.html
# https://en.wikipedia.org/wiki/Ulam_number
# input: 100

n = int(input("n=? "))
lst = [False]*(n+1)
mst = [True]*(n+1)
lst[1] = True; lst[2] = True
k = 1
while k < n:
  ''' 
   Increment k until it reaches the first integer beyond 
   the previous member of U that is representable 
   in exactly one way. 
  '''
  k += 1
  while not(lst[k] and mst[k]) and (k < n):
    k += 1
  m = min(k-1,n-k)
  # update lst and mst starting at k+1
  for i in range(1, m+1):
    mst[k+i] = mst[k+i] and \
                not(lst[k+i] and lst[i] and mst[i])
    lst[k+i] = lst[k+i] or (lst[i] and mst[i])
for i in range(1,n+1):
  if mst[i]:
    print(f"{i:4}", end='')
