
# Lucas-q5.py
# used in q-5
# input: 10 or 20
'''
 Calculate the series of Lucas numbers from
   the 0th up to the nth:
     2, 1, 3, 4, 7, 11, 18, 29, 47, 76, 123, ....

   https://en.wikipedia.org/wiki/Lucas_number

   Also calculate fib(99) and fib(101) and confirm
   that fib(99)+fib(101) = lucas(100)

'''

import math
from fibsLib import *


def lucasRec(n):
  if n <= 0:  # base cases
    return 2
  elif n == 1:  
    return 1
  else:
    return lucasRec(n-1) + lucasRec(n-2)


def lucasIter(n):
  a = 2  # first Lucas numbers: L0, L1
  b = 1
  if n <= 0: 
    return a 
  elif n == 1:
    return b
  else:
    for i in range(2, n+1): 
      a, b = b, a + b 
    return b 


# ------ main ---------- 

n = int(input("n? "))

print("Lucas numbers: 0-"+str(n))
for i in range(n+1):
  print(lucasIter(i), end=' ')  
print()

print("\nFibonacci numbers: 0-"+str(n))
for i in range(n+1):
  print(fibIter(i), end=' ')  
print()

# test relationship between Lucas and Fibonacci
print("\n   fib(99) =", fibIter(99))
print("  fib(101) =", fibIter(101))
print("lucas(100) =", lucasIter(100))
print("fib(99)+fib(101) =", fibIter(99)+fibIter(101) )
