
# josIter.py

'''
  The Josephus problem for a group of size n and step k. 
  Info: https://en.wikipedia.org/wiki/Josephus_problem

  n, k	    Output
  6, 2		[2, 4, 6, 3, 1, 5]
  5, 2		[2, 4, 1, 5, 3]
  8, 8		[8, 1, 3, 6, 5, 2, 7, 4]
  3, 9		[3, 1, 2]
  4, 3		[3, 2, 4, 1]
'''


def josIter(n, k):
  people = list(range(1, n+1))
  elims = []     # ID numbers of eliminated
  pos = 0
  while people:
    pos = (pos + k - 1) % len(people)
    elims.append(people.pop(pos))
  return elims


# ------ main ----------
n, k = map(int, input("n k? ").split())
print( josIter(n, k))
