# jos.py 
'''
  The Josephus problem for a group of size n,
  but k is hardwired to be 2. 
  Info: https://en.wikipedia.org/wiki/Josephus_problem
'''

def f(n): 
  if n < 3: 
    return 1 
  elif (n % 2 == 1): # odd
    return 2*f(n//2)+1
  else:
    return 2*f(n//2)-1 

if __name__ == "__main__":
  print("Josephus Problem for n=2..40 and k = 2")
  print(" n: position of survivor at end")
  print("         ", end ='')
  for i in range(2, 41):
    print(f"{i:2d}: {f(i):2d}; ", end = ' ')
    if i%5 == 0:
      print()
  print()