
# secantRoot.py

# https://en.wikipedia.org/wiki/Secant_method

EPS = 1E-09
MAX_ITERS = 5000

def pow4(x):
  return pow(x, 4) + 2*x - 1

def secant(fn, a, b):
  """Return the root calculated using the secant method."""
  for i in range(MAX_ITERS):
    x = b - (fn(b) * (b - a) / (fn(b) - fn(a)))
    a, b = b, x
    if abs(a - b) < EPS:
      return a, i
  return x, MAX_ITERS

root, iters = secant(pow4, 0, 1)
print(f"found root = {root:.10f} in {iters} steps")
               # 0.47462661756950747

