
# ladders.py

# https://www.thanassis.space/ladders.html
# https://en.wikipedia.org/wiki/Crossed_ladders_problem


import math
from bis import *


b = 70       # left ladder length
a = 119      # right ladder length
h = 30       # height at which ladders cross

def ladders(x):  # quadratic using d as x var
  return x**4 - (2*h)*(x**3) + (b*b - a*a)*(x-h)**2
      #  x**4 - 60*(x**3) - 9261 * (x-30)**2



# initial bounds found in python shell:
# >>> from ladders import *
# >>> ladders(17)
# -1776368
# >>> ladders(254)
# 2714410480

if __name__ == "__main__":
  d, _ = bisectIter(ladders, 17, 254)
  print("right wall height, d =", d)   # 105
  
  # d^2 - c^2 = a^2 - b^2
  c = math.sqrt(d*d - ((a*a) - (b*b)))
  print("left wall height, c =", c)   # 42
  
  # w^2 = a^2 - d^2
  w = math.sqrt((a*a) - d*d)
  print("distance between walls, w =", w)  # 56
  
