# hanoiShow.py
# Tower of Hanoi
# info: https://en.wikipedia.org/wiki/Tower_of_Hanoi
#       https://mathworld.wolfram.com/TowerofHanoi.html
# input: 4


def moves(n, src, dest, aux):
  if n == 1:
    doMove(src, dest)
  else:
    moves(n-1, src, aux, dest)
    doMove(src, dest)
    moves(n-1, aux, dest, src)
    

def doMove(fromNm, toNm):
  disk = poles[fromNm].pop()
  poles[toNm].append(disk) 
  print(f"Disk {disk}: {fromNm} --> {toNm}  :", strPoles())


def strPoles():
  return f"[ {l2s(poles[srcNm]):{sz}s} [ {l2s(poles[auxNm]):{sz}s} [ {l2s(poles[destNm]):{sz}s}"


def l2s(pole):
  return ' '.join([str(disk) for disk in pole])


# ----------------------------------
n = int(input("n? "))
sz = n*2

# a dictionary of poles to hold the disks
srcNm, auxNm, destNm,  = 'A', 'B', 'C'    # pole names
poles = {srcNm:[], auxNm:[], destNm:[]}

print("Moving", n, "disks from", srcNm, "to", destNm)

# put disks on source pole
for i in range(n, 0, -1):
  poles[srcNm].append(i)

print(' '*18,  srcNm, ' '*sz, auxNm, ' '*sz, destNm);
print(' '*18, strPoles())

moves(n, srcNm, destNm, auxNm)
