
# higherFibs.py

'''
Higher order Fibonacci Numbers
https://en.wikipedia.org/wiki/Generalizations_of_Fibonacci_numbers

We define an m-Fibonacci sequence (where m is an integer > 1) 
such that the first m-1 numbers are 0, the mth number is 1, 
and each following number is the sum of the previous m
numbers. 

For example, the first few terms of the 3-Fibonacci
sequence (the Tribonacci numbers) are

0, 0, 1, 1, 2, 4, 7, 13, 24, 44, ...

You are to write a program which will print the first n terms
of the m-Fibonacci sequence, where m and n are given input
values with m <= n. Your program should not retain more than
the last m numbers displayed. 

Try the following (n, m) values:
n m
20 2
20 3
20 4  # tetranacci numbers
20 5  % Pentanacci
'''

n, m = map(int, input("n m? ").split())

fibs = [0]*m  # storage for m fib sub-sequence
fibs[m-1] = 1

for i in range(n):
  print( fibs[0], end=' ')   # current ith fib value
  tot = fibs[0]
  for j in range(1, m):
    tot += fibs[j]
    fibs[j-1] = fibs[j]  # move numbers back one to make space 
  fibs[m-1] = tot        # insert new number
print()

