
# golden.py

import math, random
import matplotlib.pyplot as plt


PHI = (1 + math.sqrt(5)) / 2
print("phi: ", PHI)

n1 = random.randint(1, 10000)
n2 = random.randint(1, 10000)
print(n1, n2)
sums = [n1, n2]

ratios = []
for i in range(20):
  sumCurr = sums[-1] + sums[-2]
  sums.append(sumCurr) 
  ratio = sums[-1]/sums[-2]
  print(f"{i:2d} {sumCurr:10d}  {(ratio-PHI)/PHI: 15.6%}")
  ratios.append(ratio)

plt.plot(range(20), ratios)
plt.xlabel("n")
plt.ylabel("Ratio")
plt.axhline(PHI, color="Green")  # horizontal line
plt.title('Random Sums Ratio of Adjacents')

plt.show()
