
# fibTimes.py

import time, sys
from fibsLib import *
import matplotlib.pyplot as plt


# sys.setrecursionlimit(10**6)
# sys.set_int_max_str_digits(0)  # for printing the result


def timeFn(fn, n):
  startTime = time.time()
  fn(n) 
  return (time.time() - startTime)


ns = [n for n in range(10, 30)]
tmsRec = [0]*len(ns)
tmsMemo = [0]*len(ns)
tmsIter = [0]*len(ns)

for i, n in enumerate(ns):
  tmsRec[i] = timeFn(fibRec, n)
  tmsMemo[i] = timeFn(fibMemo, n)
  tmsIter[i] = timeFn(fibIter, n)

plt.plot(ns, tmsRec, label="Recursive",ls="--")
plt.plot(ns, tmsMemo, label="Memo", alpha=0.5, lw=5)
plt.plot(ns, tmsIter, label="Iterative", alpha=0.5)
plt.xlabel("n")
plt.ylabel("Secs")
plt.legend()
plt.title('Times for fib(n)')

plt.show()

