
# fibSpiral.py
# https://www.geeksforgeeks.org/python-plotting-fibonacci-spiral-fractal-using-turtle/
# draw Fibonacci spiral using Turtle
# input: 5 or 7 or 10


import turtle, math
from TurtleUtils import *
from fibsLib import *


WIN_SIZE = 500


def fibSpiral(t, fibs):
  # Draw Fibonacci squares
  t.pencolor("blue")
  t.pensize(2)
  for i in range(len(fibs)):
    if i == 0:
      t.forward(fibs[0] * scale)
      t.left(90)
    else:
      t.backward(fibs[i-1] * scale)
      t.right(90)

    t.forward(fibs[i] * scale)
    t.left(90)

    t.forward(fibs[i]/2 * scale)
    x, y = t.pos()
    writeText(t, " "+str(fibs[i]), x, y) 
    t.forward(fibs[i]/2 * scale)
    t.left(90)

    t.forward(fibs[i] * scale)

  # return the pen to starting point
  t.up()
  t.home()


  # Fibonacci Spiral Plot
  t.pencolor("red")
  t.forward(fibs[0] * scale)
  t.left(90)
  t.down()

  for i in range(len(fibs)):
    # print(fibs[i])
    dist = math.pi/180 * fibs[i] * scale
    for j in range(90):
      t.forward(dist)
      t.left(1)


# ----------- main -------------


n = int(input("n=? "))

fibVals = fibs(n+1)[1:]   # drop 0 value
print(*fibVals)

scale = WIN_SIZE/(fibVals[-1] + fibVals[-2])

t = turtle.Turtle()
t.hideturtle()
t.speed(0)

scr = t.getscreen()
scr.title('Fibonacci Spiral')

fibSpiral(t, fibVals)

scr.exitonclick()




