
# fibPhi.py
# inputs: 35

import math
from fibsLib import *
import matplotlib.pyplot as plt


#  PHI is the golden ratio, the limit of the ratio of
#  successive Fibonacci numbers:  
#    PHI = limit(N->oo) F(N+1)/F(N)
#
print("phi: ", PHI)

for n in [4, 14, 34, 44]:
  print("fibIter|Phi", n, "=", fibIter(n), "|", fibPhi(n))
print()

gen = fibGen()
fibPrev = next(gen)  # 0
fibPrev = next(gen)  # 1
print(f" 1.{fibPrev:10d}")
ratios = []
for i in range(2, 32):
  fibCurr = next(gen)
  ratio = fibCurr/fibPrev
  print(f"{i:2d} {fibCurr:10d}  {(ratio-PHI)/PHI: 15.10%}")
  ratios.append(ratio)
  fibPrev = fibCurr


plt.plot(range(2, 32), ratios)
plt.xlabel("n")
plt.ylabel("Ratio")
plt.axhline(PHI, color="Green")  # horizontal line
plt.title('Fibonacci Ratio of Adjacents')

plt.show()
