
# factTimings.py
# Time the different versions of factorial

import math
import sys, timeit
from factsLib import *
import matplotlib.pyplot as plt

dashdotdotted = (0, (3, 5, 1, 5, 1, 5))


def timer(fn, iters):
  t = timeit.timeit(fn+"(n)", globals=globals(), number=iters)
  return t


NUM_ITERS = 10000

ns = [] 
tf = []; tr = []; ti = []
tra = []; tp = []; tre = []

for n in range(10,31):
  ns.append(n)
  tf.append( timer('math.factorial', NUM_ITERS))
  tr.append( timer('factRec', NUM_ITERS))
  ti.append( timer('factIter', NUM_ITERS))
  tra.append( timer('factRange', NUM_ITERS))
  tp.append( timer('factProd', NUM_ITERS))
  tre.append( timer('factReduce', NUM_ITERS))

plt.plot(ns, tf, label="math", ls='--')
plt.plot(ns, tr, label="recursive")
plt.plot(ns, ti, label="iterative", lw=3)
plt.plot(ns, tra, label="range", ls='-.')
plt.plot(ns, tp, label="prod",ls=':', lw=5)
plt.plot(ns, tre, label="reduce", ls=':')

plt.legend()
plt.xlabel("n")
plt.ylabel("Secs")
plt.title('Times for n!')

plt.show()





