
# factApproxs.py
'''
  compare the errors in two stirling approximations
  to factorial
'''

import math
from factsLib import *
import matplotlib.pyplot as plt

ns = []
stirlings = []
stirlings2 = []

print(" n       n1")
print(" rerr 1    rerr 2")
f = 1
for n in range(20,101,10):
  f = math.factorial(n)
  s1 = stirling(n)
  s2 = stirling2(n)
  e1 = abs(f-s1)/f   # relative errors
  e2 = abs(f-s2)/f
  print()
  print(f"{n:2}! = {f:8}")
  print(s1, s2)
  print(f"{e1:.6%}  {e2:.6%}")
  ns.append(n)
  stirlings.append(e1*100)
  stirlings2.append(e2*100)


plt.plot(ns, stirlings, label="Stirling")
plt.plot(ns, stirlings2, label="Stirling 2", ls="dashed")
plt.legend()
plt.xlabel("n")
plt.ylabel("% Error")
plt.title('% Relative Errors for Stirling Approxs')

plt.show()
