
# secIntegral.py
# Andrew Davison, ad@coe.psu.ac.th, July 2025

import math

NUM_TERMS = 10

angle = float(input("Supply angle (in degrees)? "))
theta = math.radians(angle)
print("No. of terms in approx:", NUM_TERMS)

y = math.sin(theta)
approx = 0
print("Power     Approx")
for n in range(NUM_TERMS):
  power = 2*n + 1
  term = (y ** power) / power
  approx += term
  print(f"{power:2d}:  {approx}")
print()

exact = math.log(abs(math.tan(theta) + 1/math.cos(theta)))
print(f"Exact (ln|sec + tan|): {exact}")

print(f"Error: {abs(approx - exact)}")
