
# circle.py
# Andrew Davison, Sept. 2025, ad@coe.psu.ac.th

# circle using four quadratic Béziers
# see ratBez.py for rational version

import math
import matplotlib.pyplot as plt
import bezUtils


cpArcs = [ # control points for each quarter arc
  [(1,0), (1,1), (0,1)],
  [(0,1), (-1,1), (-1,0)],
  [(-1,0), (-1,-1), (0,-1)],
  [(0,-1), (1,-1), (1,0)],
]

# Reference circle
nSamps = 200
thetas = [2*math.pi*i/nSamps 
                     for i in range(nSamps+1)]
xs = [math.cos(t) for t in thetas]
ys = [math.sin(t) for t in thetas]


fig, ax = plt.subplots(figsize=(7, 7))

for ctrlPts in cpArcs:
  curveX, curveY = bezUtils.bezierCurve(ctrlPts, nSamps)
  ax.plot(curveX, curveY, 'b')
  bezUtils.drawControlPts(plt, ctrlPts)

# plot the circle
plt.plot(xs, ys, color="orange", lw=5, alpha=0.5)

plt.axis("equal")
plt.title("Circle using four Bézier curves")
plt.grid(True)
plt.show()
