
# bezPath.py
# Andrew Davison, Sept. 2025, ad@coe.psu.ac.th

import matplotlib.pyplot as plt
from matplotlib.patches import PathPatch
import bezUtils


# control points (choose one of these)
ctrlPts = [(0,0),(0.5,1),(1,0)]
# ctrlPts = [(0,0),(0.2,1),(1,0.8),(0.8,0)]

bezierPath = bezUtils.bezPath(ctrlPts)
patch = PathPatch(bezierPath, 
          facecolor="none", edgecolor="blue", lw=2,
          label=f"Bézier Curve (deg {len(ctrlPts)-1})")

plt.figure(figsize=(6, 4))
ax = plt.gca()
ax.add_patch(patch)

bezUtils.drawControlPts(plt, ctrlPts)

plt.axis("equal")
plt.title("Bézier Curve (Path)")
plt.grid(True)
plt.legend()
plt.show()
