
# bezBern.py
# Andrew Davison, Sept. 2025, ad@coe.psu.ac.th

import matplotlib.pyplot as plt
import bezUtils

# control points (choose one)

# ctrlPts = [(0,0), (0.5,1),(1,0)]
# ctrlPts = [(0,0),(0.2,0.9),(0.8,-0.6),(1,0)]
ctrlPts = [(0,0),(0.2,0.9),(0.8,0.6),(1,0)]
'''
ctrlPts = [(0,0),(0.2,0.9),(0.5,0.2),
           (0.8,-0.6),(1,0)]
'''
'''
ctrlPts = [(0,0), (0.15,0.8), (0.35,-0.4),
           (0.65,1.0), (0.85,-0.3), (1,0)]
'''
'''
ctrlPts = [(0,0),(0.2,0.9),(0.5,-0.5), 
           (0.7,1.0),(1.0,0)]
'''
'''
ctrlPts = [(0,0),(1,3),(2,2),(3,-1), 
           (4,2),(5,0),(6,1) ]
'''


curveX, curveY = bezUtils.bezierCurve(ctrlPts, 200)

plt.figure(figsize=(6, 4))

plt.plot(curveX, curveY, 
        label=f"Bézier Curve (deg {len(ctrlPts)-1})")
bezUtils.drawControlPts(plt, ctrlPts)

plt.axis("equal")
plt.title("Bézier Curve (Bernstein)")
plt.grid(True)
plt.legend()
plt.show()
