
# phasePlot.py
# Andrew Davison, ad@coe.psu.ac.th, Nov. 2025

# Visualize a cubic using an enhanced phase plot.


import complexUtils

def cubic(z, a, b, c, d):
  return a*z**3 + b*z**2 + c*z + d


a, b, c, d = map(float, input("Enter cubic coefs (a b c d): ").split())
size = int(input("Range (or 3): ") or "3")

expr = f"lambda x: cubic(x, {a}, {b}, {c}, {d})"
env = { "cubic": cubic,
        "__builtins__": {} } # restrict builtins
func = eval(expr, env)

realMin, realMax, imagMin, imagMax = -size, size, -size, size
print(f"Real range: [{realMin}, {realMax}]")
print(f"Imaginary range: [{imagMin}, {imagMax}]")
extent = (realMin, realMax, imagMin, imagMax)

complexUtils.showPhase(func, extent, expr)


