
# ellipsesTG.py
# Andrew Davison, ad@coe.psu.ac.th, Oct. 2025
'''
Python versions of some LOGO functions from 

Turtle Geometry: The Computer as a Medium for Exploring Mathematics,
H.Abelson and A.Disessa

The page references in the comments below 
refer to this book.
'''


import math
from turtle import Turtle


def circle(t):   # p.10
  for _ in range(360):
    t.forward(1)  # try 2
    t.right(1)


def poly(t, side, angle):   # p.15
  for _ in range(360):  # was forever
    t.forward(side)
    t.right(angle)

def ellipse(t, side, e):  # p.440
  n = 0 
  for _ in range(360):
    t.right(n) 
    t.forward(side)
    t.left(n)  
    t.left(n) 
    t.forward(side*e) 
    t.right(n)  
    n += 1


def duopoly(t, side1, angle1, side2, angle2):   # p.114
  c = 0 
  for _ in range(200):
    vector(t, c * angle1, side1) 
    vector(t, c * angle2, side2) 
    c += 1

def vector(t, direction, length): 
  t.setheading(direction) 
  t.forward(length)


# ---------------------

t = Turtle()
t.hideturtle()
t.speed(0)
scr = t.getscreen()
scr.title('Ellipses (TG)')

# circle(t)
# poly(t, 1, 1)
ellipse(t, 2, 0.5)
# duopoly(t, 4, 2, 8, -2)    # p.116
# duopoly(t, 2, 2, 4, -2)    

scr.exitonclick()


