
# coshPlot.py
# Andrew Davison, Nov 2025, ad@coe.psu.ac.th
'''
Plot y = cosh(t)/t for positive t values and find the minimum
using scipy brentq root finder on the derivative.
'''

import math
import matplotlib.pyplot as plt
from scipy.optimize import brentq

def f(t):
  return math.cosh(t) / t

def fPrime(t):
  return (t * math.sinh(t) - math.cosh(t)) / (t**2)


# Find minimum by finding where derivative equals zero
tMin = brentq(fPrime, 0.1, 3)
yMin = f(tMin)
print(f"Min: ({tMin:.6f}, {yMin:.6f})")

ts = [0.1 + i * 0.0049 for i in range(1000)]
ys = [f(t) for t in ts]

# Create the plot, and mark minimum
plt.figure()
plt.plot(ts, ys, 'b-', lw=2, label=r'$Y = \frac{\cosh(t)}{t}$')
plt.plot(tMin, yMin, 'ro', markersize=10, 
               label=f'Min: ({tMin:.4f}, {yMin:.4f})')

plt.grid(True, alpha=0.3)
plt.xlabel('t = H/2a')
plt.ylabel('Y = 2R/H')
# plt.title(r'$y = \frac{\cosh(t)}{t}$')
plt.legend()
plt.tight_layout()
plt.show()