
# phaseCMath.py
# Andrew Davison, ad@coe.psu.ac.th, Nov. 2025

'''
Visualizes cmath complex functions by plotting a domain 
colored phase diagram with contour lines for phase and modulus
  - phase lines are black, modulus lines are white

The user supplies the function name, and the axes ranges are read from a funcs.txt file. 

A nice online tool for plotting any complex function in this
way is:
  https://www.dynamicmath.xyz/complex/function-plotter/hsv.htm#
    - click on last 'phase' box to add contours
    - click on "?" for info
'''

import cmath
import complexUtils


data = complexUtils.loadCMFuncs()
if not data:
  exit()

funcName = input("Enter function name: ").strip().lower()
if not funcName in data:
  print(f"No entry found for '{funcName}'.")
  exit()

if not hasattr(cmath, funcName):
  print(f"No cmath function named '{name}' found.")
  exit()

func = getattr(cmath, funcName)

print(f"Plotting {funcName}(z)")
realMin, realMax, imagMin, imagMax = data[funcName]
print(f"Real range: [{realMin}, {realMax}]")
print(f"Imaginary range: [{imagMin}, {imagMax}]")
extent = (realMin, realMax, imagMin, imagMax)
title = f"cmath.{funcName}(z)"

complexUtils.showPhase(func, extent, title)


