
# tennis.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025
'''
  see tennis2.py for additional node ordering 
'''

import graphviz as gv

TEMP_FNM = 'temp_graph'

t = gv.Digraph(format='png')
t.attr(label='Tennis Tournament')
t.attr(rankdir='LR')
t.attr('node', shape='box')

# player nodes
t.node('Player 1',shape='none'); t.node('Player 2',shape='none')
t.node('Player 3',shape='none'); t.node('Player 4',shape='none')
t.node('Player 5',shape='none'); t.node('Player 6',shape='none')
t.node('Player 7',shape='none'); t.node('Player 8',shape='none')

# game nodes
t.node('Game 1'); t.node('Game 2'); t.node('Game 3')
t.node('Game 4'); t.node('Game 5'); t.node('Game 6')
t.node('Game 7')

# link players and games
t.edge('Player 1','Game 1'); t.edge('Player 2','Game 1')
t.edge('Player 3','Game 2'); t.edge('Player 4','Game 2')
t.edge('Player 5','Game 3'); t.edge('Player 6','Game 3')
t.edge('Player 7','Game 4'); t.edge('Player 8','Game 4')
t.edge('Game 1', 'Game 5'); t.edge('Game 2', 'Game 5')
t.edge('Game 3', 'Game 6'); t.edge('Game 4', 'Game 6')
t.edge('Game 5', 'Game 7'); t.edge('Game 6', 'Game 7')

t.render(filename=TEMP_FNM, view=True, cleanup=True)

