
# someShapes.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025

'''
https://graphviz.readthedocs.io/en/stable/examples.html
https://graphviz.org/doc/info/shapes.html
'''

import graphviz

TEMP_FNM = 'temp_graph'

dg = graphviz.Digraph(format='png')
dg.attr(rankdir='LR')   # LR or TB
dg.attr(label='Some Shapes')

dg.node('n1', '{record|{a|b|<f0>c}}', shape='record')
   # uses graph's rankdir to interpret '|'

dg.node('n2', label=(
  '''<<table border="0" cellborder="1" cellspacing="0">
      <tr>
        <td colspan="3">table</td>
      </tr>
      <tr>
        <td port="f0">d</td>
        <td port="f1">e</td>
        <td port="f2">f</td>
      </tr>
    </table>
  >''' ), shape='plaintext') 

dg.edge('n1:f0', 'n2:f2')

# pentagon 
dg.node('P', '5-sided', shape='polygon', sides='5')
# hexagon
dg.node('H', '6-sided', shape='polygon', sides='6')
# distorted hexagon
dg.node('E','Distorted',shape='polygon',sides='6',distortion='0.7')
# skewed hexagon
dg.node('F', 'Skewed', shape='polygon', sides='6', skew='0.7')
# rotated hexagon
dg.node('G', 'Rot 30',shape='polygon',sides='6',orientation='30')
dg.edges(['PH', 'HE', 'EF', 'FG'])
   # e.g. PH means link nodes P --> H

dg.render(filename=TEMP_FNM, view=True, cleanup=True)