
# engines.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025

# https://graphviz.org/docs/layouts/
'''
dot - draws directed graphs.

neato - draws undirected graphs using 'spring' models.

fdp - draws undirected graphs using a 'spring' model;
      stands for Force-Directed Placement.
sfdp - filter for drawing large undirected graphs;
       stands for Scalable Force-Directed Placement.

circo - draws graphs using a circular layout.

osage - filter for drawing clustered graphs.
patchwork - filter for drawing clustered graphs 
            as squarified treemaps.
twopi - filter for radial layouts of graphs.
'''

import graphviz

TEMP_FNM = 'temp_graph'

engs = ['dot', 'neato', 'fdp', 'sfdp', 'circo', 
        'osage', 'patchwork', 'twopi']
eng = input(", ".join(engs) + "? ")
if eng not in engs:
  print(f'\'{eng}\' not recognized, using dot')
  eng = 'dot'
g = graphviz.Graph(format='png', engine=eng)
       # use Graph or Digraph

g.attr(rankdir='LR')     # for dot
g.attr(overlap='false')  # avoids node overlapping
g.attr(splines='true')   # helps edges to avoid crossing nodes
g.attr(oneblock='true')  # for circo

g.attr(label='Graph Using Engine ' + g.engine)

g.edge('1', '2')
g.edge('2', '3')
g.edge('3', '1')
g.edge('1', '4')
g.edge('4', '5')
g.edge('4', '6')
g.edge('4', '7')
g.edge('6', '8')
g.edge('8', '9')
g.edge('9', '10')
g.edge('9', '7')
g.edge('10', '7')
g.edge('6', '7')

g.render(filename=TEMP_FNM, view=True, cleanup=True)
