
# circuit.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025

'''
https://graphviz.org/docs/attrs/image/
'''

import graphviz

TEMP_FNM = 'temp_graph'

g = graphviz.Digraph(format='png')
g.attr(rankdir='LR')
g.attr(label='Combinational Circuit')

# input nodes (p, q, r) with no shapes 
g.node('p', '', shape='none')
g.node('q', '', shape='none')
g.node('r', '', shape='none')

# gates using images for AND, OR, and NOT
g.node('AND', image='andGate.png', 
              imagescale='true', shape='none')
g.node('OR', image='orGate.png', 
              imagescale='true', shape='none')
g.node('NOT\l', image='notGate.png', 
                # align='left', labeljust='l',
                imagescale='true', shape='none')

# output node
g.node('OUT', 'OUT', shape='doublecircle')

# label edges with Boolean logic
g.edge('p', 'AND', label='p')
g.edge('q', 'AND', label='q')
g.edge('r', 'NOT\l', label='r')
g.edge('NOT\l', 'OR', label='¬r') 
g.edge('AND', 'OR', label='p ˄ q') 
g.edge('OR', 'OUT', label='(p ˄ q) ˅ ¬r')

g.render(filename=TEMP_FNM, view=True, cleanup=True)

