
# automaton.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025

import graphviz

TEMP_FNM = 'temp_graph'

dg = graphviz.Digraph(format='png')
dg.attr(rankdir='LR')
dg.attr(label='An Automaton')
dg.attr('edge', fontcolor='blue')

# start arrow with no node
dg.node('', shape='none')
dg.edge('', 's0', label='Start')

# nodes
dg.node('s0', shape='doublecircle')
dg.node('s3', shape='doublecircle')

with dg.subgraph(name='cluster1') as c1:
  c1.attr(label='Internal', style='rounded,dashed')
  c1.node('s1')   # nodes inside a cluster
  c1.node('s2')

# transitions
dg.edge('s0','s0',label='0'); dg.edge('s0','s1',label='1')
dg.edge('s1','s2',label='1'); dg.edge('s2','s3',label='0')
dg.edge('s3','s3',label='0, 1')
dg.edge('s2','s2',label='1'); dg.edge('s1','s3',label='0')

dg.render(filename=TEMP_FNM, view=True, cleanup=True)

