
# arcs.py
# Andrew Davison, ad@coe.psu.ac.th, May 2025

'''
https://graphviz.org/doc/info/attrs.html
https://graphviz.org/doc/info/colors.html

'''

import graphviz

def ns(name, val):
  return '<<I>'+name+'</I><SUB>'+str(val)+'</SUB>>'

TEMP_FNM = 'temp_graph'
ALPHA_BLUE = '#0096FF80'  # 50% alpha

dg = graphviz.Digraph(format='png', engine='neato',
      node_attr={'shape':'point'},
      edge_attr={'fontsize':'12',
                 'arrowhead':'open', 
                 # 'color':'cadetblue3'
                 'color':ALPHA_BLUE
                })
dg.attr(label='Directed Graph')

for v in ['v1','v2','v3','v4','v5','v6','v7']:
  dg.node(v, '', xlabel=v)

dg.edge('v1','v2',label=ns('e',1))
dg.edge('v2','v3',label=ns('e',2))
dg.edge('v3','v4',label=ns('e',3))
dg.edge('v4','v6',label=ns('e',4))
dg.edge('v6','v5',label=ns('e',6))
dg.edge('v6','v7',label=ns('e',7))
dg.edge('v6','v1',label=ns('e',8))
dg.edge('v2','v7',label=ns('e',9))
dg.edge('v3','v5',label=ns('e',5))

dg.render(filename=TEMP_FNM, view=True, cleanup=True)


