
# flowers.py
''''
A Python translation of the wonderful Logo program
explained in:
  "Problem Solving with Logo:
  Using Turtle Graphics to Redraw a Design"
  William Weinreb
  BYTE, Nov. 1982, pp.118-134
  https://archive.org/details/byte-magazine-1982-11/page/n119/mode/2up
'''

from turtle import Turtle

SCALE = 3   # to change the size of the entire design


def flowers(t):
  # build 5 interlocking wheels and the center
  
  t.penup() 
  for _ in range(5):
    t.forward(64.65*SCALE)
    t.pendown()
    wheel(t, t.pos())
    t.penup()
    t.back(64.65*SCALE)
    t.right(72)

  t.penup() 
  t.home()
  t.right(16)  # 36
  t.forward(24.5*SCALE)
  t.right(198)
  t.pendown()
  centerpiece(t, 46, 143.4)



def wheel(t, initpos):
  t.right(54)
  for _ in range(4):
    pentpiece(t, initpos)
     # make a ring of pentagonal spirals; a wheel rim

  t.pendown()
  t.left(36)
  for _ in range(5):
    tripiece(t, initpos)
     # make a ring of triangular spirals; fills the wheel

  t.left(36)
  for _ in range(5):
    t.pendown()
    t.right(72)
    t.forward(28*SCALE)
    t.penup() 
    t.back(28*SCALE)
  t.left(54)



def tripiece(t, initpos):
  # produce a pair of mirrored triangular spirals
  oldh = t.heading()

  t.pendown()
  t.back(2.5*SCALE)
  tripolyr(t, 31.5)
  t.penup() 
  t.setpos(initpos)
  t.setheading(oldh)

  t.pendown()
  t.back(2.5*SCALE)
  tripolyl(t, 31.5)
  t.penup() 
  t.setpos(initpos)
  t.setheading(oldh)

  t.left(72)



def pentpiece(t, initpos):
  # produce a pair of mirrored pentagonal spirals
  oldh = t.heading()
  t.penup()

  t.forward(29*SCALE)
  t.pendown()
  for _ in range(5):
    t.forward(18*SCALE)
    t.right(72)
  pentr(t, 18, 75)
  t.penup() 
  t.setpos(initpos)
  t.setheading(oldh)

  t.forward(29*SCALE)
  t.pendown()
  for _ in range(5):
    t.forward(18*SCALE)
    t.left(72)
  pentl(t, 18, 75)
  t.penup() 
  t.setpos(initpos)
  t.setheading(oldh)

  t.left(72)



def pentl(t, side, angle):
  # pentagonal left spiral
  if side < 2:
    return
  t.forward(side*SCALE)
  t.left(angle)
  pentl(t, side-0.38, angle)


def pentr(t, side, angle):
  # pentagonal right spiral
  if side < 2:
    return
  t.forward(side*SCALE)
  t.right(angle)
  pentr(t, side-0.38, angle)



def tripolyr(t, side):
  # triangular right spiral
  if side < 4:
    return
  t.forward(side*SCALE)
  t.right(111)
  t.forward(side/1.78*SCALE)
  t.right(111)
  t.forward(side/1.3*SCALE)
  t.right(146)
  tripolyr(t, side * 0.75)


def tripolyl(t, side):
  # triangular left spiral
  if side < 4:
    return
  t.forward(side*SCALE)
  t.left(111)
  t.forward(side/1.78*SCALE)
  t.left(111)
  t.forward(side/1.3*SCALE)
  t.left(146)
  tripolyl(t, side * 0.75)



def centerpiece(t, s, a):
  # central, star-shaped spiral
  t.forward(s*SCALE)
  t.left(a)
  if s < 7.5: 
    return
  centerpiece(t, s-1.2, a)


# ----------- main -----------------

t = Turtle()
t.hideturtle()
t.speed(0)
scr = t.getscreen()
scr.title('Logo Flowers')

t.left(90)   # facing upwards

flowers(t)

print("Finished the flowers")
scr.exitonclick()
