
# drunks.py

# Plot the paths of drunken turtles

import random
from turtle import Turtle


MAX_STEPS = 50
STEP_SIZE = 50
colors=["red","orange","green","blue","purple","violet"]

n = int(input("n? "))
# create n turtles
ts = [ Turtle() for _ in range(n)]
for i in range(n):
  ts[i].setheading(360*random.random())
  ts[i].speed(0)
  ts[i].pencolor(colors[i % len(colors)])
scr = ts[0].getscreen()
scr.title('Drunk Turtles')

# move randomly for max steps
for t in range(MAX_STEPS):
  for i in range(n):
    ts[i].left(360 * random.random())
    ts[i].forward(random.randint(STEP_SIZE//5, STEP_SIZE))

scr.exitonclick()
