
# drawPolys.py
# input: 10  or  30
import math
from turtle import Turtle

LENGTH = 100

def drawPolygon(t, numSides):
  # draw a regular polygon with a specified no. of sides
  lineLen = LENGTH/(2*math.sin(math.pi/numSides))
  if (numSides > 2) and (lineLen > 0):
    angle = 360 / numSides
    for i in range(numSides):
      t.forward(lineLen)
      t.right(angle)

def rotatePolys(t, numSides, rotAngle):
  # draw a series of polygons in a circle, 
  # spaced out at rotAngle degrees
  numShapes = 360 // rotAngle
  for shape in range(numShapes):
    drawPolygon(t, numSides)
    t.right(rotAngle)

def polyCircles(t, rotAngle):
  # draw four circles of polys in different colors
  t.pensize(3)
  t.pencolor('blue')
  rotatePolys(t, 3, rotAngle) # triangles
  t.pencolor('red')
  rotatePolys(t, 4, rotAngle) # squares
  t.pencolor('green')
  rotatePolys(t, 5, rotAngle) # penatgons
  t.pencolor('orange')
  rotatePolys(t, 6, rotAngle) # hexagons


if __name__ == "__main__":
  rotAngle = int(input("angle? "))

  # create a turtle
  t = Turtle()
  t.hideturtle()
  t.speed(0)
  scr = t.getscreen()
  scr.title('Draw Patterns')
  
  polyCircles(t, rotAngle)
  
  scr.exitonclick()