
# sierpinskiCA.py

# Rule - the status of current cell value is True
# if only one of the two neighbors at the previous step is True
# otherwise, the current cell status is False

import time

SIZE = 64


# the current status of SIZE cells
ca = [False]*SIZE
ca[SIZE//2] = True
print("".join( ["*" if cell else " " for cell in ca]))

step = 1
isAlive = True
while isAlive:
  caNext = []
  for i in range(SIZE):
    # interior cells - check the neighbors
    if i > 0 and i < SIZE-1:
      caNext.append(not (ca[i-1] == ca[i+1]))  # True if neighbors different
    elif i == 0:      # left-most cell
      caNext.append(ca[1])
    elif i == SIZE-1:  # right-most cell
      caNext.append(ca[SIZE-2]) 

  # draw current state
  print("".join( ["*" if cell else " " for cell in caNext]))
  ca = caNext[:]

  isAlive = (ca.count(False) != SIZE)   # is there something in CA?
  time.sleep(0.25)
  step += 1

