
# julia.py

# https://scipython.com/book/chapter-7-matplotlib/problems/p72/the-julia-set/

# https://users.math.yale.edu/public_html/People/frame/Fractals/MandelSet/welcome.html

'''
The Julia set for a given complex number c is a set of points related to the Mandelbrot function. Instead of fixing z and varying c, we fix c and vary z. 

Those points z for which the modified Mandelbrot function stays bounded are in the Julia set; those for which the sequence diverges to infinity are not in the set. 

All points z of interest lie in a box centered at the origin. 

'''

import math

import matplotlib.pyplot as plt


MAX_ITER = 1000
Z_MAX = 10

# parameters for the plot
imWidth, imHeight = 500, 500
xmin, xmax = -1.5, 1.5
xwidth = xmax - xmin
ymin, ymax = -1.5, 1.5
yheight = ymax - ymin

c = complex(-0.3, 0.71)
# c = complex(0.44, 0.29)
# c = complex(-0.775, 0.177)
# c = complex(-0.12, 0.765)
# c = complex(-0.1, 0.65)


# julia[y][x]
julia = [[0 for x in range(imWidth)] for y in range(imHeight)]


for x in range(imWidth):
  for y in range(imHeight):
    iters = 0
    # Map pixel position to a point in the complex plane
    z = complex(x / imWidth * xwidth + xmin,
                y / imHeight * yheight + ymin)

    # Do the iterations
    while abs(z) <= Z_MAX and iters < MAX_ITER:
      z = z**2 + c
      iters += 1
    julia[y][x] = iters / MAX_ITER


plt.imshow(julia, interpolation='nearest', cmap="hot")
plt.xticks([])
plt.yticks([])
plt.title("Julia Set for " + str(c))
plt.show()
