
# cantorset.py
# info: https://en.wikipedia.org/wiki/Cantor_set
# input: 5 or 6

import turtle, random
from TurtleUtils import *

WIDTH = 900


def cantor(t, xStart, xEnd, lvl):
  y = 100 - 20*(lvl+1)
  drawLine(t, xStart, y, xEnd, y)

  if lvl < level:
    len = (xEnd-xStart)/3
    cantor(t, xStart, xStart+len, lvl+1)
    cantor(t, xEnd-len, xEnd, lvl+1)


# ----------------------- main ---------------------------

level = int(input("level? "))
t = turtle.Turtle()
scr = t.screen
scr.title('Cantor Set')
t.hideturtle()
t.speed(0)

t.pensize(5)
cantor(t, -WIDTH/2, WIDTH/2, 1)

scr.exitonclick()




