
# wire3D.py
# https://matplotlib.org/stable/plot_types/3D/wire3d_simple.html#sphx-glr-plot-types-3d-wire3d-simple-py
'''
  A wireframe plot of a 3D equation 
'''

import matplotlib.pyplot as plt
import numpy as np

X = np.linspace(-1, 2, 20)  # increase step for more detail
Y = np.linspace(-1, 2, 20)
X, Y = np.meshgrid(X, Y)  # numpy output required
Z = np.sin(np.sqrt(X**2 + Y**2))

ax = plt.axes(projection = '3d')
ax.plot_wireframe(X, Y, Z)
plt.title('3D Wireframe Plot')
plt.xlabel('x')
plt.ylabel('y')
ax.set_zlabel('z')  # no plt.zlabel()
plt.show()