
# taylorcos.py
'''
   Three line plots on one graph: y = cos(x) and 
   two approximations using its Taylor polynomials 
   for degrees 2 and 4.

https://matplotlib.org/stable/plot_types/basic/plot.html#sphx-glr-plot-types-basic-plot-py
'''

import math
from frange import *
import matplotlib.pyplot as plt

xs = linspace(-6, 6, 50)

# Plot y = cos(x)
ys = [ math.cos(x) for x in xs]
plt.plot(xs, ys, 'b', label ='cos(x)')  # solid blue

# Plot degree 2 Taylor polynomial
ys2 = [ (1 - x**2/2) for x in xs]
plt.plot(xs, ys2, 'r-.', label ='Degree 2')  # red dot dashes

# Plot degree 4 Taylor polynomial
ys4 = [(1 - x**2/2 + x**4/24) for x in xs]
plt.plot(xs, ys4, 'g:', label ='Degree 4')  # green dots

plt.grid(True, linestyle =':')  # a dotted grid pattern
plt.xlabel('x-axis')
plt.ylabel('y-axis')
plt.xlim([-6, 6])
plt.ylim([-4, 4])

plt.legend()
plt.title('Taylor Polynomials of cos(x) at x = 0')
plt.show()
