
# spiral.py
# https://matplotlib.org/stable/gallery/pie_and_polar_charts/polar_demo.html
'''
  A spiral generated using polar coordinates, with some customizations.
  Also see butterfly.py.

  The customizations mean I need to access the axis (ax), and so I use
  subplot projection and ax.plot() rather than plt.polar() from
  butterfly.py
'''

import math
import matplotlib.pyplot as plt
from frange import *

# generate angles from the radii
rs = linspace(0, 2, num=100)
thetas = [ 2*math.pi*r for r in rs]

ax = plt.subplot(projection='polar')
ax.plot(thetas, rs)

ax.set_rmax(2)
ax.set_rticks([0.5, 1, 1.5, 2])  # Less radial ticks
ax.set_rlabel_position(-22.5)  # clockwise degrees
       # Move radial labels away from plotted line

plt.title("Spiral")
plt.show()

