
# sineSlider.py
# uses a slider to control the frequency of a sine wave 
# https://matplotlib.org/stable/gallery/widgets/

import math
from frange import *

import matplotlib.pyplot as plt
from matplotlib.widgets import Slider


def update(value):
  ys = [ math.sin(value * math.pi * x) for x in thetas]
  line.set_ydata(ys)
  fig.canvas.draw_idle()

fig, ax = plt.subplots()
plt.subplots_adjust(bottom=0.2)
thetas = linspace(0, math.pi, 300)
ys = [ math.sin(5 * math.pi * x) for x in thetas]
line, = ax.plot(thetas, ys)

# frequency slider
freqAxis = plt.axes([0.25, 0.1, 0.65, 0.03])
freqSlider = Slider(freqAxis, 'Frequency [Hz]',
                           0, 10, valinit=5)
                        # min, max, initial value
freqSlider.on_changed(update)
plt.show()
