
# points3D.py
# https://matplotlib.org/stable/gallery/mplot3d/
# https://matplotlib.org/stable/plot_types/3D/scatter3d_simple.html#sphx-glr-plot-types-3d-scatter3d-simple-py
'''
  A 3D 'tornado' draw either as a line of a scatter plot.
'''

import math
from frange import *
import matplotlib.pyplot as plt

ax = plt.figure().add_subplot(projection ='3d')

# define data
zs = linspace(0, 1, 100)
xs = [ z * math.sin(25 * z) for z in zs]
ys = [ z * math.cos(25 * z) for z in zs]

plt.plot(xs, ys, zs)    # line
# plt.scatter(xs, ys, zs=zs, s=70)  # points; s is size

plt.title('3D plot')
plt.xlabel('x')
plt.ylabel('y')
ax.set_zlabel('z')   # no plt.zlabel()
plt.show()
