
# plotSeries.py
# https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.subplots.html
'''
  Draws a line and scatter plot side-by-side. The left-hand graph shows the
  on-going summation for a series from 0 to n, while the right-hand
  graph shows the terms used at each step.

'''
import matplotlib.pyplot as plt

n = 50
terms = [0]*n
sums = [0]*n

for i in range(1, n):
  terms[i] = 1/i
     # 1/i  or 1/(i*i)  or 1/(2**(i-1))
  sums[i] =  sums[i-1] + terms[i]


_, ax = plt.subplots(1, 2, figsize=(10,5))
                  # row x column
# left-hand plot
ax[0].plot(sums)
ax[0].set_title("Summation")

# right-hand plot
ax[1].scatter(range(n), terms, s=2)
ax[1].set_title("Terms")

plt.show()