
# parabolaCustom.py
# https://matplotlib.org/stable/plot_types/basic/plot.html#sphx-glr-plot-types-basic-plot-py
'''
  A parabolic line plotted using 100 points between x = -2 and 2
  with many customizations to the graph.
  See parabola.py for the basic version.
'''

# ways to customize plots


import matplotlib.pyplot as plt
from frange import *

xs = linspace(-2, 2, 10)
ys = [x**2 for x in xs]

fig = plt.figure(figsize = (10, 8)) # bigger window

plt.axis('equal')  # same scaling used on both axes
plt.xlim(-2.5, 2.5)
plt.minorticks_on()
plt.xticks( list(frange(-2.5, 3, 0.5)))

plt.axhline(0, color="Green")  # horizontal line
plt.axvline(0, color="Green")  # vertical line

plt.plot(xs, ys, alpha = 0.4, label ='$y = x^2$', # Latex
		color ='red', linestyle ='--',
		linewidth = 2, marker ='D', 
		markersize = 5, mfc ='blue', mec ='blue')   
                      # marker face and edge colors

plt.title('Parabola plot', fontsize = 20) # bigger title
plt.xlabel('x')
plt.ylabel('y')
fig.canvas.manager.set_window_title('Parabola plot')
             # give the window title bar a better name

fig.text(0.8, 0.15, 'Some info', 
     fontsize = 12, color ='green',
     ha ='right', va ='bottom', 
     alpha = 0.7)    # draw text at (0.8, 0.15) offset

plt.grid(alpha =.6, linestyle ='--')  # grid lines
plt.legend(loc="upper left")     # move the legend

print("Saving plot to savedplot.png")
plt.savefig("savedplot.png", dpi=300)

plt.show()
