
# parabola.py
# https://matplotlib.org/stable/plot_types/basic/plot.html#sphx-glr-plot-types-basic-plot-py
'''
  A parabolic line plotted using 100 points between x = -2 and 2.
  See parabolaCustom.py for a customized version.
'''

import matplotlib.pyplot as plt
from frange import *

xs = linspace(-2, 2, 100)
ys = [x**2 for x in xs]
plt.plot(xs, ys, label="y=x^2")
plt.title("Parabola")
plt.xlabel("x")
plt.ylabel("y")
plt.legend()
plt.show()
