
# loglog.py
# https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.loglog.html
# https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.semilogy.html
# https://matplotlib.org/stable/api/_as_gen/matplotlib.pyplot.semilogx.html
'''
  Plot a line for x^3 for values of x = 1 to 10.
  if the loglog(), semilogy() or semilogx() calls are uncommented
  then the axes are changed to logarithmic scales.
'''

import matplotlib.pyplot as plt
from frange import *

xs = linspace(1, 10, 500)
ys = [x**3 for x in xs]
# plt.plot(xs, ys)

# plt.semilogx(xs, ys)  # x-axis log
# plt.semilogy(xs, ys)  # y-axis log
plt.loglog(xs, ys)   # both axes use logs
plt.title("Log plot")
plt.show()