
# errParabola.py
# https://matplotlib.org/stable/plot_types/stats/errorbar_plot.html#sphx-glr-plot-types-stats-errorbar-plot-py
'''
  A parabolic line with error bars at the plotted points. The errors 
  increase from 0.2 to 0.5 for the 10 points.
'''

import matplotlib.pyplot as plt
from frange import *

n = 10
xs = linspace(-2, 2, n)
ys = [x**2 for x in xs]
plt.plot(xs, ys, label="y=x^2")

yErrs = linspace(0.2, 0.5, n)
plt.errorbar(xs, ys, yerr = yErrs, fmt ='o')

plt.title("Parabola with Error Bars")
plt.xlabel("x")
plt.ylabel("y")
plt.legend()
plt.show()
