
# days13Custom.py
# https://matplotlib.org/stable/plot_types/basic/bar.html#sphx-glr-plot-types-basic-bar-py
'''
  A customized bar chart that shows the day distribution of the 13th date across
  all the months of 1800-2201. See days13.py for a basic version.

  The bar chart's vertical axis starts at 680 rather than 0. The bars are
  narrower, and topped by their numerical values.
'''


from datetime import date
import matplotlib.pyplot as plt


WEEKDAYS = ['Mon', 'Tue', 'Wed', 'Thur', 'Fri', 'Sat', 'Sun']
days13 = [0]*7

for year in range(1800, 2201):
  for month in range(1,13):
    days13[ date(year, month, 13).weekday()] += 1
    '''
      weekday() returns the day of the week as an integer,
      indexed from 0 for Monday
    '''

MIN = 680
bots=[MIN]*7
ds = [val-MIN for val in days13]   # cut off the heights

plt.bar(WEEKDAYS, ds, width=0.4, bottom=bots)  
                           # set vertical baseline

xlocs, xlabs = plt.xticks()
for i, v in enumerate(days13):
  plt.text(xlocs[i] - 0.2, v + 0.08, str(v))

plt.title('The 13th Days')
plt.show()
