
# days13.py
# https://matplotlib.org/stable/plot_types/basic/bar.html#sphx-glr-plot-types-basic-bar-py
'''
  A basic bar chart that shows the day distribution of the 13th date across
  all the months of 1800-2201. See daysCustom.py for an improved visualization.
'''


from datetime import date
import matplotlib.pyplot as plt


WEEKDAYS = ['Mon','Tue','Wed','Thur','Fri','Sat','Sun']
days13 = [0]*7
for year in range(1800, 2201):
  for month in range(1,13):
    days13[ date(year, month, 13).weekday()] += 1
print(*days13)
plt.bar(WEEKDAYS, days13)  # labels, heights
plt.title('The 13th Days')
plt.show()
